/*------------------------------------------------------------------------------*
 * File Name:				 													*
 * Creation: 																	*
 * Purpose: OriginC Source C file												*
 * Copyright (c) ABCD Corp.	2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010		*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *------------------------------------------------------------------------------*/
 
////////////////////////////////////////////////////////////////////////////////////
// Including the system header file Origin.h should be sufficient for most Origin
// applications and is recommended. Origin.h includes many of the most common system
// header files and is automatically pre-compiled when Origin runs the first time.
// Programs including Origin.h subsequently compile much more quickly as long as
// the size and number of other included header files is minimized. All NAG header
// files are now included in Origin.h and no longer need be separately included.
//
// Right-click on the line below and select 'Open "Origin.h"' to open the Origin.h
// system header file.
#include <Origin.h>
////////////////////////////////////////////////////////////////////////////////////


////////////////////////////////////////////////////////////////////////////////////
// Include your own header files here.


////////////////////////////////////////////////////////////////////////////////////
// Start your functions here.
///This function show how to access Matrix data in OriginC
//
void AccessMatrix()
{
	MatrixLayer ml;        //create new matrix layer
	ml.Create("MatrixData");
	
	Matrix MatData;        //new Matrix Object attached to the Matrix Layer
	MatData.Attach(ml);
	
	MatData.SetSize(3,4); //set the Matrix Size
	
	matrix mat =         //declear a matrix for Matrix operation.
		  { 
			{1, 2, 3, 4},
			{5, 6, 7, 8},
			{9, 10,11,12}
		  };
	        
	MatData = mat;      //put the matrix value to Matrix
	
	//set and get Matrix cell data
	MatData[2][3] = 100;  //set one cell value, Row 3, Col 4 value is 100
	
	double dVal = MatData[1][3];  //get the cell value Row 2 Col 4 and output;
	out_double("The Value on Corridate X = 2, Y = 4 is ", dVal);
	
	//set and get Matrix data by vector
	vector vDataRad;	//declear a new vector 
	int nRows, nCols; 
	
	nCols = MatData.GetNumCols(); //get the Matrix cols number and rows number
	nRows = MatData.GetNumRows();
	
	for(int ii = 0; ii < nRows * nCols; ii++)       //set the vector value to random data
	{
		vDataRad.Add(ran());
		vDataRad[ii] *= 10;
	}
	
	MatData.SetByVector(vDataRad, TRUE );		//set the matrix by the vector
	
	nRows = nRows * 2; nCols = nCols * 2;       //resize the matrix 
	MatData.SetSize(nRows, nCols, true);
	
	for(ii = 0; ii < nRows; ii++)               //reset the matrix value
	{
		for(int jj = 0; jj < nCols; jj++)
		{
			MatData[ii][jj] = ii * ii + jj * jj;
		}
	}
	
	MatData.GetAsVector(vDataRad, TRUE);        //get the matrix by the vector
	
	for(ii = 0; ii < nRows; ii++)               //output the matrix value by vector
	{
		for(int jj = 0; jj < nCols; jj++)
		{
			string strIndex;
			strIndex.Format("Row %d, Col %d value is ", ii, jj);
			out_double(strIndex, vDataRad[ii * nCols + jj]);
		}
	}	
	
	//access data by datarange	
	DataRange dr;
	dr.Add(ml, 0, "Y");  		//construct a data range for the first matrix object for this matrix sheet
	
	GraphPage gp;
	gp.Create("CMAP");
	GraphLayer gl = gp.Layers(0);
	
	if( gl.AddPlot(dr, IDM_PLOT_SURFACE_COLORMAP) >= 0 ) // returns plot index if plot successfully 
		gl.Rescale();
	
}